/*
 * Decompiled with CFR 0.152.
 */
package common.ui;

import com.nokia.mid.appl.calc2.Local;
import common.control.Calculator2;
import common.control.ConfigurationManager;
import common.ui.ButtonPanel;
import common.ui.DisplaySizes;
import common.ui.EditPanel;
import common.util.Tools;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Graphics;

public abstract class CalculatorCanvas
extends Canvas
implements CommandListener {
    protected static final Command COMMAND_LOAN_CALCULATOR = new Command(Local.getText(21), 1, 2);
    protected static final Command COMMAND_CLEAR = new Command(Local.getText(17), 2, 0);
    protected final Calculator2 midlet;
    protected final int backgroundColor;
    protected DisplaySizes displaySize = null;
    protected EditPanel editPanel = null;
    protected ButtonPanel buttonPanel = null;
    protected boolean clearCommandPresent = false;

    public CalculatorCanvas(Calculator2 midlet) {
        this.midlet = midlet;
        this.backgroundColor = ConfigurationManager.getInstance().getBackgroundColor();
        int w = this.getWidth();
        int h = this.getHeight();
        this.displaySize = DisplaySizes.determineDisplaySize(w, h);
        if (this.displaySize == null) {
            midlet.showError("Error", "This screen size (" + w + ", " + h + ") is not supported! MIDlet closing...");
            try {
                Thread.sleep(5000L);
                midlet.closeMIDlet();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics g) {
        Tools.getInstance().triggerGarbageCollection();
        if (this.backgroundColor != -1) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        this.editPanel.paint(g);
    }

    public void addClearCommand() {
        this.addCommand(COMMAND_CLEAR);
        this.clearCommandPresent = true;
    }

    public void removeClearCommand() {
        this.removeCommand(COMMAND_CLEAR);
        this.clearCommandPresent = false;
    }

    public boolean isClearCommandPresent() {
        return this.clearCommandPresent;
    }
}

